withLimits <- function(x,lower,upper)structure(x,lower=lower,upper=upper,class="withLimits")

"[.withLimits" <- function(x,i,...){
  structure(unclass(x)[i],
    lower=attr(x,"lower")[i],
    upper=attr(x,"upper")[i],
    class="withLimits")
}

panel.envelope <- function(x,y,groups,subscripts,env.col="gray80",...){
      lower <- attr(y,"lower")
      upper <- attr(y,"upper")
      if(missing(groups)){
        panel.polygon(c(x,rev(x)),c(lower,rev(upper)),border="transparent",col=env.col)
        panel.xyplot(x,y,subscripts=subscripts,...)
      }
      else{
        g <- groups[subscripts]
        x.g <- split(x,g)
        lower.g <- split(lower,g)
        upper.g <- split(upper,g)
        mapply(function(x,lower,upper){
              panel.polygon(c(x,rev(x)),c(lower,rev(upper)),border="transparent",col=env.col)
              },
              x.g,lower.g,upper.g)
        panel.superpose(x,y,groups=groups,subscripts=subscripts,...)
      }
    }